const video = document.getElementById('video');
navigator.mediaDevices.getUserMedia({ video: true })
    .then(stream => video.srcObject = stream)
    .catch(err => alert("Tidak bisa akses kamera: " + err));

function captureAndVerify() {
    const canvas = document.getElementById('canvas');
    const context = canvas.getContext('2d');
    context.drawImage(video, 0, 0, canvas.width, canvas.height);
    canvas.toBlob(function(blob) {
        const formData = new FormData();
        formData.append('webcam', blob);

        $.ajax({
            url: '<?= BASEURLKU; ?>faceid/cek',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(res) {
                if (res.status) {
                    $('#result').html("✅ ID Santri ditemukan: <strong>" + res.id + "</strong>");
                } else {
                    $('#result').html("❌ Wajah tidak cocok dengan data.");
                }
            },
            error: function() {
                alert('Gagal menghubungi server.');
            }
        });
    }, 'image/jpeg');
}