<div class="main-panel">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="bg-white p-6 rounded-lg shadow-md animate__animated animate__fadeIn">
                    <h2 class="text-2xl font-bold mb-4 text-gray-800">Data Santri</h2>
                    <button class='btn btn-success py-2 px-4 mb-4' data-toggle='modal' data-target='#modaltambah' data-backdrop='static' data-keyboard='false'>Tambah Data</button>
                    <div class="table-responsive">
                        <table id="tblxdt" class="display table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Aksi</th>
                                    <th>NISN</th>
                                    <th>Nama Santri</th>
                                    <th>Nama Wali</th>
                                    <th>No HP Wali</th>
                                    <th>Status Hubungan</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" role="dialog" id="modaltambah">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-size: 20px;">Tambah Data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label>NISN</label>
                        <input type="text" class="form-control ftambah" id="txtnisn">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Nama Santri</label>
                        <input type="text" class="form-control ftambah" id="txtnamasantri">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Nama Wali</label>
                        <input type="text" class="form-control ftambah" id="txtnamawali">
                    </div>
                    <div class="form-group col-md-6">
                        <label>No HP</label>
                        <input type="text" class="form-control ftambah" id="txtnohp">
                    </div>
                    <div class="form-group col-md-6 jedaobyek">
                        <label>Status Hubungan</label>
                        <input list="statusList" class="form-control ftambah" id="txtstatus" placeholder="Ketik atau pilih status">
                        <datalist id="statusList">
                            <option value="Ayah">
                            <option value="Ibu">
                            <option value="Saudara">
                        </datalist>
                    </div>
                    <div class="form-group col-6 jedaobyek">
						<label>Input Foto Wali (*.jpg)</label>
						<input type="file" class="form-control" id="txtfoto" accept="image/jpeg">
					</div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" id="btnSimpan" onclick="tambah_data()">Simpan</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" role="dialog" id="modalupdate">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-size: 20px;">Update Data</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label>NISN</label>
                        <input type="text" class="form-control fupdate" id="txtnisne">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Nama Santri</label>
                        <input type="text" class="form-control fupdate" id="txtnamasantrie">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Nama Wali</label>
                        <input type="text" class="form-control fupdate" id="txtnamawalie">
                    </div>
                    <div class="form-group col-md-6">
                        <label>No HP</label>
                        <input type="text" class="form-control fupdate" id="txtnohpe">
                    </div>
                    <div class="form-group col-6 jedaobyek">
                        <label>Ganti Foto Wali (*.jpg)</label>
                        <input type="file" class="form-control" id="txtfotoe" accept="image/jpeg">
                    </div>
                    <div class="form-group col-md-6 jedaobyek">
                        <label>Status Hubungan</label>
                        <input list="statusList" class="form-control fupdate" id="txtstatuse" placeholder="Ketik atau pilih status">
                        <datalist id="statusList">
                            <option value="Ayah">
                            <option value="Ibu">
                            <option value="Saudara">
                        </datalist>
                    </div>
                    <div class="form-group col-6 jedaobyek">
						<label>Foto</label>
						<img id="previewFoto" alt="Preview Foto" style="display:block; margin-top:10px; max-width:100px; cursor:pointer;" onclick="perbesarFoto(this)">
					</div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btnUpdate" onclick="update_data()">Update</button>
            </div>
        </div>
    </div>
</div>
<script>
    $("#mnwali").addClass("active");
    let tabel = $("#tblxdt").DataTable({
        "ajax" : "<?= BASEURLKU; ?>datawali"
    });
    function reset(){
		$(".ftambah").val("");
        $("#cbojk").val("Laki-Laki").change();
		$("#cbostatus").val("Y").change();
	}
    function tambah_data(){
    let nisn = $("#txtnisn").val();
    let santri = $("#txtnamasantri").val();
    let wali = $("#txtnamawali").val();
    let noHp = $("#txtnohp").val();
    let status = $("#txtstatus").val();
    let files = document.getElementById("txtfoto").files;
    
    if (nisn == "" || santri == "" || wali == "" || noHp == "" || status == "" || files.length === 0){
        swal({title: "Gagal", text: "Ada Isian Yang Masih Kosong", icon: "error"});
        return;
    }

    let namafile = files[0].name;
    let ekstensi = namafile.split('.').pop().toLowerCase();
    if(ekstensi !== "jpg"){
        swal({title: 'Tambah Gagal', text: 'File Harus Ber-ekstensi .jpg', icon: 'error'});
        return;
    }

    swal({text:"Proses Tambah ...", icon: iconpreloader, button: false, closeOnClickOutside: false, closeOnEsc: false});

    let formData = new FormData();
    formData.append("ekstensi", "jpg");
    formData.append("file", files[0]);
    formData.append("nisn", nisn);
    formData.append("santri", santri);
    formData.append("wali", wali);
    formData.append("noHp", noHp);
    formData.append("status", status);

    var xhttp = new XMLHttpRequest();
    xhttp.open("POST", "<?= BASEURLKU; ?>tambahwali", true);
    xhttp.onreadystatechange = function(){
        if(this.readyState == 4 && this.status == 200){
            swal.close();
            let respon = this.responseText;
            try {
                let data = JSON.parse(respon); // HAPUS atob()
                if(data.kode == "1"){
                    swal({title: "Berhasil", text: data.pesan, icon: "success"}).then((Ok) => {
                        if(Ok){
                            $("#modaltambah").modal("hide");
                            tabel.ajax.reload(null, false);
                            reset();
                            window.location = "";
                        }
                    });
                } else {
                    swal({title: "Gagal", text: data.pesan, icon: "error"});
                }
            } catch (e) {
                swal({title: "Gagal", text: "Respon Server Tidak Valid", icon: "error"});
            }
        } else {
            swal({title: 'Gagal', text: 'Respon Server Gagal', icon: 'error'});
        }
    };
    xhttp.send(formData);
}

    function filter(el){
        let nisn = $(el).data("kode");
        if (nisn == "") {
            swal({title: "Gagal", text: "Data Tidak Terdeteksi", icon: "error"});
            return;
        }
        $.ajax({
            url: "<?= BASEURLKU; ?>filterwali",
            method: "POST",
            data: {nisnx: nisn},
            success: function(response){
                try {
                    let data = JSON.parse(response);
                    if (data.kode == "1") {
                        $("#txtnisne").val(nisn);
                        $("#txtnamasantrie").val(data.nama_santri);
                        $("#txtnamawalie").val(data.nama_wali);
                        $("#txtnohpe").val(data.no_hp);
                        $("#txtstatuse").val(data.status);
                        let gambarSrc = "<?= BASEURLKU . 'writable/uploads/walisantri/'; ?>" + nisn + ".jpg";
                        $("#previewFoto").attr("src", gambarSrc);
                        $("#modalupdate").modal({
                            backdrop: 'static',
                            keyboard: false
                        }).modal("show");
                    } else {
                        swal({title: "Gagal", text: data.pesan, icon: "error"});
                    }
                } catch (e) {
                    swal({title: "Error", text: "Respon Server Tidak Valid", icon: "error"});
                }
            },
            error: function(){
                swal({title: "Gagal", text: "Koneksi Ke Controller Gagal", icon: "error"});
            }
        });
    }

    function update_data(){
        let nisn = $("#txtnisne").val();
        let santri = $("#txtnamasantrie").val();
        let wali = $("#txtnamawalie").val();
        let noHp = $("#txtnohpe").val();
        let status = $("#txtstatuse").val();
        let files = document.getElementById("txtfotoe").files;

        if (nisn == "" || santri == "" || wali == "" || noHp == "" || status == ""){
            swal({title: "Gagal", text: "Ada Isian Yang Masih Kosong", icon: "error"});
            return;
        }

        let formData = new FormData();
        formData.append("nisnx", nisn);
        formData.append("santrix", santri);
        formData.append("walix", wali);
        formData.append("noHpx", noHp);
        formData.append("status", status);
        if (files.length > 0) {
            formData.append("ekstensi", "jpg");
            formData.append("file", files[0]);
        }

        $.ajax({
            url: "<?= BASEURLKU; ?>updatewali",
            method: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response){
                let data = JSON.parse(response);
                if (data.kode == "1") {
                    swal({title: "Berhasil", text: data.pesan, icon: "success"}).then(() => {
                        $("#modalupdate").modal("hide");
                        tabel.ajax.reload(null, false);
                    });
                } else {
                    swal({title: "Gagal", text: data.pesan, icon: "error"});
                }
            },
            error: function(){
                swal({title: "Gagal", text: "Koneksi ke server gagal", icon: "error"});
            }
        });
    }

    function hapus_data(el){
        let nisn = $(el).data("kode");
        if(nisn == ""){
            swal({title: "Gagal", text:"Nomor Induk Masih Kosong", icon: "error"});
            return;
        }
        swal({
            title: 'Konfirmasi',
            text: "Anda Yakin Ingin Menghapus Data Ini?",
            icon: 'warning',
            buttons: {
                confirm: {text: 'Yakin', className: 'btn btn-primary'},
                cancel: {visible: true, text: 'Tidak', className: 'btn btn-danger'}
            }
        }).then((hapus) => {
            if(hapus){
                $.ajax({
                    url: "<?= BASEURLKU; ?>hapuswali",
                    method: "POST",
                    data: {nisnx: nisn},
                    cache: "false",
                    success: function(response){
                        let data = JSON.parse(response);
                        if(data.kode == "1"){
                           swal({title: "Berhasil", text: data.pesan, icon: "success"}).then((Ok) => {
                                if(Ok){
                                    tabel.ajax.reload(null, false);
                                }
                            })
                        } else {
                            swal({title: "Gagal",text: data.pesan, icon:"error"});
                        }
                    },
                    error: function(){
                        swal({title: "Gagal", text: "koneksi Ke Controller Gagal", icon: "error"});
                    }
                })
            }
        })
    }
    function perbesarFoto(el) {
        let swalContent = document.createElement("div");
        swalContent.innerHTML = `
            <div style="position: relative; display: inline-block;">
                <button id="closeSwal" 
                    style="width: fit-content; background-color: red; text-color: white; border-radius: 10px; border-color: transparent; position: absolute; top: 0; right: 0; z-index: 3;">X</button>
                <img src="${el.src}" style="width: 100%; max-width: 500px; border-radius: 5px;">
            </div>
        `;

        swal({
            content: swalContent,
            buttons: false,
            closeOnClickOutside: false
        });

        document.getElementById("closeSwal").addEventListener("click", function() {
            swal.close();
        });
    }
</script>