<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Pondok Pesantren Nur Khodijah 3</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
</head>
<body class="bg-gray-100">
    
    <!-- Header -->
    <header class="bg-green-700 text-white p-5 shadow-lg animate__animated animate__fadeInDown">
        <div class="container mx-auto flex justify-between items-center">
            <h1 class="text-2xl font-bold">Pondok Pesantren Nur Khodijah 3</h1>
            <nav>
                <ul class="flex space-x-4">
                    <li><a href="<?= BASEURLKU; ?>viewlogin" class="hover:underline">Login</a></li>
                    <li><button id="aboutBtn" class="hover:underline">About</button></li>
                </ul>
            </nav>
        </div>
    </header>
    
    <!-- Hero Section -->
    <section class="bg-green-600 text-white text-center py-20 animate__animated animate__fadeIn">
        <div class="container mx-auto">
            <h2 class="text-4xl font-bold">Selamat Datang di Pesantren Tahfidz</h2>
            <p class="mt-4 text-lg">Mencetak generasi Qur'ani yang berakhlak mulia.</p>
            <a href="#profil" class="mt-6 inline-block bg-white text-green-600 px-6 py-2 rounded-lg shadow-md hover:bg-gray-200">Get Started</a>
        </div>
    </section>
    
    <!-- Profil Section -->
    <section id="profil" class="container mx-auto py-20 px-4 animate__animated animate__fadeInLeft">
        <h2 class="text-3xl font-bold text-center text-green-700">Profil Pesantren</h2>
        <p class="mt-4 text-center text-gray-700">Pondok Pesantren Nur Khodijah 3 berfokus pada tahsin dan tahfidz Al-Qur'an untuk mencetak santri yang berkualitas.</p>
    </section>
    
    <!-- Program Section -->
    <section id="program" class="bg-gray-200 py-20 px-4 animate__animated animate__fadeInRight">
        <div class="container mx-auto text-center">
            <h2 class="text-3xl font-bold text-green-700">Program Unggulan</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
                <div class="bg-white p-5 shadow-lg rounded-lg animate__animated animate__zoomIn">
                    <h3 class="text-xl font-bold text-green-700">Tahfidz 30 Juz</h3>
                    <p class="text-gray-700 mt-2">Menghafal Al-Qur'an dengan metode yang sistematis.</p>
                </div>
                <div class="bg-white p-5 shadow-lg rounded-lg animate__animated animate__zoomIn">
                    <h3 class="text-xl font-bold text-green-700">Tahsin Al-Qur'an</h3>
                    <p class="text-gray-700 mt-2">Membantu santri memperbaiki bacaan Al-Qur'an.</p>
                </div>
                <div class="bg-white p-5 shadow-lg rounded-lg animate__animated animate__zoomIn">
                    <h3 class="text-xl font-bold text-green-700">Kajian Islam</h3>
                    <p class="text-gray-700 mt-2">Mempelajari ilmu agama Islam lebih dalam.</p>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Kontak Section -->
    <section id="kontak" class="container mx-auto py-20 px-4 animate__animated animate__fadeInUp">
        <h2 class="text-3xl font-bold text-center text-green-700">Hubungi Kami</h2>
        <p class="mt-4 text-center text-gray-700">Jika Anda memiliki pertanyaan, silakan hubungi kami melalui kontak berikut.</p>
        <div class="text-center mt-6">
            <p class="text-lg text-gray-800"><strong>Email:</strong> info@nurkhodijah3.com</p>
            <p class="text-lg text-gray-800"><strong>Telepon:</strong> 0812-3456-7890</p>
        </div>
    </section>
    
    <!-- About Modal -->
    <div id="aboutModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center">
        <div class="bg-white p-6 rounded-lg shadow-lg max-w-lg text-center animate__animated animate__zoomIn">
            <h2 class="text-2xl font-bold text-green-700">Tentang Pesantren</h2>
            <p class="mt-4 text-gray-700">Pondok Pesantren Nur Khodijah 3 berfokus pada tahsin dan tahfidz Al-Qur'an untuk mencetak santri yang berkualitas dalam ilmu dan akhlak.</p>
            <button id="closeModal" class="mt-4 px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">Tutup</button>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="bg-green-700 text-white text-center py-4 animate__animated animate__fadeInUp">
        <p>&copy; 2024 Pondok Pesantren Nur Khodijah 3. Semua Hak Dilindungi.</p>
    </footer>
    
    <script>
        document.getElementById('aboutBtn').addEventListener('click', function() {
            document.getElementById('aboutModal').classList.remove('hidden');
        });
        document.getElementById('closeModal').addEventListener('click', function() {
            document.getElementById('aboutModal').classList.add('hidden');
        });
    </script>
    
</body>
</html>