<div class="main-panel">
    <div class="row">
        <div class="col-md-12">
            <div class="card p-4 shadow-lg rounded-lg">
                <div class="card-body">
                    <h2 class="text-2xl font-bold mb-4 text-gray-800 text-center">Face ID Wali Santri</h2>
                    
                    <div class="row">
                        <!-- Kolom Kamera -->
                        <div class="col-md-6 text-center">
                            <div style="position: relative; display: inline-block;">
                                <!-- Video mirror -->
                                <video id="video" width="320" height="240" autoplay playsinline 
                                    style="border-radius: 10px; transform: scaleX(-1); background: #000;"></video>
                                <!-- Overlay fokus -->
                                <div id="focus-overlay" style="
                                    position: absolute;
                                    pointer-events: none;
                                    border: 3px solid lime;
                                    border-radius: 50%;
                                    width: 150px;
                                    height: 150px;
                                    top: 50%;
                                    left: 50%;
                                    transform: translate(-50%, -50%);
                                "></div>
                            </div>
                            <br><br>
                            <button id="scanBtn" class="btn btn-primary mt-3">
                                Cek Wajah
                            </button>
                            <canvas id="canvas" width="320" height="240" style="display:none;"></canvas>
                        </div>

                        <!-- Kolom Hasil -->
                        <div class="col-md-6">
                            <h4 class="font-bold mb-3">Hasil Scan</h4>
                            <table class="table table-bordered">
                                <tr>
                                    <th>NISN</th>
                                    <td id="nisnData">-</td>
                                </tr>
                                <tr>
                                    <th>Nama Santri</th>
                                    <td id="namaSantriData">-</td>
                                </tr>
                                <tr>
                                    <th>Nama Wali</th>
                                    <td id="namaWaliData">-</td>
                                </tr>
                                <tr>
                                    <th>Status Hubungan</th>
                                    <td id="statusHubunganData">-</td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td id="statusData">-</td>
                                </tr>
                                <tr>
                                    <th>Confidence</th>
                                    <td id="confidenceData">-</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    const video = document.getElementById('video');
    const canvas = document.getElementById('canvas');
    const context = canvas.getContext('2d');
    const scanBtn = document.getElementById('scanBtn');
    const focusOverlay = document.getElementById('focus-overlay');

    // elemen hasil
    const nisnData = document.getElementById('nisnData');
    const namaSantriData = document.getElementById('namaSantriData');
    const namaWaliData = document.getElementById('namaWaliData');
    const statusHubunganData = document.getElementById('statusHubunganData');
    const statusData = document.getElementById('statusData');
    const confidenceData = document.getElementById('confidenceData');

    let stream;

    // akses kamera
    navigator.mediaDevices.getUserMedia({ video: true })
    .then(s => {
        stream = s;
        video.srcObject = stream;
    })
    .catch(err => {
        alert("Tidak bisa akses kamera: " + err);
    });

    function stopCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            video.srcObject = null;
        }
    }

    function captureAndSend() {
    swal({
        title: 'Memproses Data...',
        text: 'Silakan tunggu beberapa saat',
        icon: 'info',
        buttons: false,
        closeOnClickOutside: false,
        closeOnEsc: false,
        content: {
            element: "div",
            attributes: {
                innerHTML: '<div class="loader" style="margin:20px auto;"></div>'
            },
        }
    });

    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;

    // mirror effect
    context.save();
    context.translate(canvas.width, 0);
    context.scale(-1, 1);
    context.drawImage(video, 0, 0, canvas.width, canvas.height);
    context.restore();

    const dataURL = canvas.toDataURL('image/jpeg', 0.7);

    fetch("<?= BASEURLKU; ?>cek", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ foto: dataURL })
    })
    .then(res => res.text())
    .then(text => {
        try {
            return JSON.parse(text);
        } catch {
            throw new Error("Respon server bukan JSON");
        }
    })
    .then(data => {
        swal.close(); // tutup swal loading
        stopCamera();
        focusOverlay.style.display = "none";

        if (data.status === "Cocok") {
            nisnData.innerText = data.nisn || "-";
            namaSantriData.innerText = data.nama_santri || "-";
            namaWaliData.innerText = data.nama_wali || "-";
            statusHubunganData.innerText = data.hubungan || "-";
            statusData.innerText = data.status || "-";
            confidenceData.innerText = (data.confidence ? data.confidence.toFixed(2) + "%" : "-");
        } else {
            statusData.innerText = data.status || "Tidak Cocok";
        }

        scanBtn.disabled = false;
        scanBtn.innerText = "Scan Ulang";
        scanBtn.onclick = () => location.reload();
    })
    .catch(err => {
        swal.close();
        stopCamera();
        focusOverlay.style.display = "none";
        statusData.innerText = "Error: " + err.message;
        scanBtn.disabled = false;
        scanBtn.innerText = "Scan Ulang";
        scanBtn.onclick = () => location.reload();
    });
}

    scanBtn.onclick = captureAndSend;
</script>
