<style>
    body {
        background-color: #f5f8fa;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #333;
    }
    .dashboard-title {
		margin-top: -20px;
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 20px;
        text-align: center;
        color: #2c3e50;
    }
    .dashboard-cards {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        justify-content: center;
        margin-bottom: 30px;
    }

    .dashboard-card {
        background: white;
        flex: 1 1 250px;
        max-width: 300px;
        padding: 30px 20px;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.07);
        text-align: center;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        cursor: default;
    }
    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.15);
    }
    .dashboard-card i {
        font-size: 50px;
        color: #27ae60;
        margin-bottom: 15px;
    }
    .dashboard-card h4 {
        font-size: 18px;
        margin-bottom: 10px;
        color: #34495e;
        font-weight: 600;
    }
    .dashboard-card h1 {
        font-size: 48px;
        color: #2c3e50;
        margin: 0;
        font-weight: 700;
        letter-spacing: 2px;
    }

    /* Grafik container */
    #blokgrafik {
        min-height: 350px;
    }
    /* Responsive tweaks */
    @media (max-width: 768px) {
        .dashboard-cards {
            flex-direction: column;
            align-items: center;
        }
        .dashboard-card {
            max-width: 90%;
        }
    }
</style>

<div class="main-panel">
    <h2 class="dashboard-title">Dashboard</h2>

    <div class="dashboard-cards">
        <?php
        $jmlsantri = 0;
        $jmlwali = 0;

        if (is_array($datax) && count($datax) > 0) {
            $d = $datax[0];
            $jmlsantri = number_format($d->jmlsantri ?? 0, 0, ",", ".");
            $jmlwali = number_format($d->jmlwali ?? 0, 0, ",", ".");
        }
        ?>
        <div class="dashboard-card">
            <i class="fas fa-user"></i>
            <h4>Jumlah Santri</h4>
            <h1><?= $jmlsantri ?></h1>
        </div>
        <div class="dashboard-card">
            <i class="fas fa-users"></i>
            <h4>Jumlah Wali</h4>
            <h1><?= $jmlwali ?></h1>
        </div>
    </div>

    <div class="row" style="margin-top: 15px;">
        <div class="col-md-12">
            <div class="card shadow-sm rounded-lg">
                <div class="card-body" id="blokgrafik"></div>
            </div>
        </div>
    </div>
</div>

<script>
    $("#mnberanda").addClass("active");
    grafik();

    function grafik() {
        Highcharts.chart('blokgrafik', {
            chart: { type: 'column' },
            title: { 
                text: 'Setoran Per Tanggal - Bulan ' + 
                      new Date().toLocaleString('default', { month: 'long' }) + 
                      ' ' + new Date().getFullYear(),
                style: { fontWeight: 'bold', fontSize: '18px' }
            },
            xAxis: {
                categories: [
                    <?php
                    $tahun_bulan = date('Y-m');
                    $jumlah_hari = date('t');
                    for ($i = 1; $i <= $jumlah_hari; $i++) {
                        echo "'$i',";
                    }
                    ?>
                ],
                title: { text: 'Tanggal' },
                labels: { style: { fontSize: '12px' } }
            },
            yAxis: { 
                title: { text: 'Jumlah Nasabah' },
                labels: { style: { fontSize: '12px' } }
            },
            tooltip: {
                shared: true,
                valueSuffix: ' kunjungan'
            },
            series: [{
                name: 'Setoran',
                data: [
                    <?php
                        $tahun_bulan = date('Y-m');
                        $jumlah_hari = date('t');
                        $tgl_jumlah = array_fill_keys(
                            array_map(
                                fn($i) => $tahun_bulan . '-' . str_pad($i, 2, '0', STR_PAD_LEFT),
                                range(1, $jumlah_hari)
                            ), 
                            0
                        );
                        foreach ($grafikx as $row) {
                            $tgl_jumlah[$row->tanggal] = $row->jumlah_kunjungan;
                        }
                        echo implode(',', $tgl_jumlah);
                    ?>
                ],
                color: '#28a745',
                borderRadius: 5,
                dataLabels: {
                    enabled: true,
                    style: {
                        fontSize: '11px',
                        fontWeight: 'bold',
                        color: '#1b5e20',
                        textOutline: 'none'
                    }
                }
            }],
            credits: { enabled: false },
            legend: { enabled: false }
        });
    }
</script>
