<?php
namespace App\Controllers;

class Face extends BaseController
{
    private $apiKey = "V3E_OFmO31rRID8YoDkbZxUIlX_WGsdC";
    private $apiSecret = "DRkJc4atkRc8I10wCbZNrvlZ3KBp1d6c";

    public function __construct(){
        $h = $this->CekLogin2("form", "fa321");
        $this->aksesc = $h[2];
        $this->hasilc = $h;
    }

    public function index(){
        $x["dtlogin"] = $this->hasilc[1];
        $x["akses"] = $this->hasilc[2];
        $x["dtmenu"] = $this->hasilc[3];
        $x["dtform"] = $this->hasilc[4];
        $x["ids"] = $this->hasilc[5];
        $x["idf"] = $this->hasilc[6];
        $x["hal"] = "face";
        return view("basis", $x);
    }

   public function cek()
{
    $json = $this->request->getJSON();

    if (!$json || empty($json->foto)) {
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Data foto tidak ditemukan'
        ])->setStatusCode(400);
    }

    $imgBase64 = $json->foto;
    if (strpos($imgBase64, ',') === false) {
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Format foto tidak valid'
        ])->setStatusCode(400);
    }

    // Ambil bagian base64 saja
    $imgData = explode(',', $imgBase64)[1];

    // Simpan sementara
    $tempPath = WRITEPATH . 'uploads/temp_face.jpg';
    if (!is_dir(dirname($tempPath))) {
        mkdir(dirname($tempPath), 0777, true);
    }
    file_put_contents($tempPath, base64_decode($imgData));

    // Folder foto wali santri
    $folder = WRITEPATH . 'uploads/walisantri/';
    if (!is_dir($folder)) {
        return $this->response->setJSON([
            'status' => 'error',
            'message' => 'Folder walisantri tidak ditemukan'
        ])->setStatusCode(500);
    }

    $files = glob($folder . '*.jpg');
    $found = false;
    $bestMatch = null;
    $bestConfidence = 0;

    foreach ($files as $file) {
        $similarity = $this->compareFaces($tempPath, $file);

        if ($similarity >= 80 && $similarity > $bestConfidence) {
            $nisn = pathinfo($file, PATHINFO_FILENAME);
            $found = true;
            $bestMatch = $nisn;
            $bestConfidence = $similarity;
        }
    }

    @unlink($tempPath); // hapus foto sementara

    if ($found) {
        // Ambil data santri dari model
        $dataSantri = $this->mface->dataSantri($bestMatch);
        $dataSantri = is_array($dataSantri) ? $dataSantri[0] : $dataSantri; // ambil objek pertama jika array

        if (!empty($dataSantri)) {
            $id         = kodeotomatis1();
            $nisn       = $dataSantri->nisn ?? '';
            $namaSantri = $dataSantri->nama_santri ?? '';
            $namaWali   = $dataSantri->nama_wali ?? '';
            $noHp       = $dataSantri->no_hp ?? '';
            $status     = $dataSantri->status_hubungan ?? '';

            // Simpan ke DB
            $proses = $this->mface->TambahData($id, $nisn, $namaSantri, $namaWali, $noHp, $status, IdLogin());

            return $this->response->setJSON([
                'kode'       => $proses == "1" ? '1' : '0',
                'pesan'      => $proses == "1" ? 'Data berhasil disimpan' : 'Gagal menyimpan data',
                'status'     => 'Cocok',
                'nisn'       => $nisn,
                'nama_santri'=> $namaSantri,
                'nama_wali'  => $namaWali,
                'no_hp'      => $noHp,
                'hubungan'   => $status,
                'confidence' => $bestConfidence
            ]);
        } else {
            return $this->response->setJSON([
                'kode'       => '0',
                'pesan'      => 'Data santri tidak ditemukan di database',
                'status'     => 'Cocok',
                'nisn'       => $bestMatch,
                'confidence' => $bestConfidence
            ]);
        }
    }

    return $this->response->setJSON([
        'status'     => 'Tidak ditemukan kecocokan',
        'confidence' => 0
    ]);
}

    private function compareFaces($path1, $path2){
        $url = "https://api-us.faceplusplus.com/facepp/v3/compare";

        if (!file_exists($path1) || !file_exists($path2)) {
            file_put_contents(WRITEPATH . 'logs/facepp_error.log', "File tidak ditemukan: $path1 atau $path2" . PHP_EOL, FILE_APPEND);
            return 0;
        }
        $cfile1 = new \CURLFile(realpath($path1), mime_content_type($path1), basename($path1));
        $cfile2 = new \CURLFile(realpath($path2), mime_content_type($path2), basename($path2));
        $data = [
            'api_key'    => $this->apiKey,
            'api_secret' => $this->apiSecret,
            'image_file1'=> $cfile1,
            'image_file2'=> $cfile2
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // bypass SSL verify kalau perlu
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            $error = curl_error($ch);
            file_put_contents(WRITEPATH . 'logs/facepp_error.log', "cURL error: $error" . PHP_EOL, FILE_APPEND);
            curl_close($ch);
            return 0;
        }
        curl_close($ch);
        // Simpan response mentah
        file_put_contents(WRITEPATH . 'logs/facepp_debug.log', $response . PHP_EOL, FILE_APPEND);
        $result = json_decode($response, true);
        if (isset($result['error_message'])) {
            file_put_contents(WRITEPATH . 'logs/facepp_error.log', "Face++ error: " . $result['error_message'] . PHP_EOL, FILE_APPEND);
        }
        return $result['confidence'] ?? 0;
    }
}
