<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use CodeIgniter\I18n\Time;
use App\Models\Msistem;
use App\Models\Mlog;
use App\Models\Mme776;
use App\Models\Mle409;
use App\Models\Mfo110;
use App\Models\Mka556;
use App\Models\Mdr699;
use App\Models\Mak755;
use App\Models\Mwali;
use App\Models\Mface;
use App\Models\Mriwayat;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = ["custom_function","url","redirect"];

    /**
     * Constructor.
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        $this->encrypter = \Config\Services::encrypter();
        $this->session = \Config\Services::session();
        $this->msistem = new Msistem();
        $this->mlog = new Mlog();
        $this->mme776 = new Mme776();
        $this->mle409 = new Mle409();
        $this->mfo110 = new Mfo110();
        $this->mka556 = new Mka556();
        $this->mdr699 = new Mdr699();
        $this->mak755 = new Mak755();
        $this->mwali = new Mwali();
        $this->mface = new Mface();
        $this->mriwayat = new Mriwayat();
    }

    public function CekLogin(){
        helper("custom_function");
        $this->mlog = new Mlog();
        //------------------------------------
        $dtl = IdLogin2();
        $status = false;
        if($dtl != ""){
            $dtlogin = $this->mlog->CekLogin($dtl[0], $dtl[1]);
            if(is_array($dtlogin)){
                if(count($dtlogin)>0){
                    $status = true;
                }
            }
        }
        return $status ? [$status, $dtlogin] : [$status];
    }

    public function CekLogin2($jenis, $idform) {
        helper("custom_function");
        $this->mlog = new Mlog();
        //------------------------------------
        $dtl = IdLogin2();
        $status = false;
    
        if ($dtl != "") {
            $dtlogin = $this->mlog->CekLogin($dtl[0], $dtl[1]);
            if (is_array($dtlogin) && count($dtlogin) > 0) {
                if ($jenis == "dashboard") {
                    $idsistem_sistem = $idform;
                } else {
                    $dataform = $this->mlog->CekSistem($idform);
                    if (is_array($dataform) && count($dataform) > 0) {
                        foreach ($dataform as $cx) {
                            $idsistem_sistem = $cx->id_sistem;
                        }
                    }
                }
    
                $idsistem_user = [];
                foreach ($dtlogin as $dl) {
                    $idlevel = $dl->id_level;
                    array_push($idsistem_user, $dl->id_sistem);
                }
    
                if (array_search($idsistem_sistem, $idsistem_user) !== false) {
                    $status = true;
                    $dtmenu = $this->mlog->CekMenu($idsistem_sistem, $idlevel);
                    $dtform = $this->mlog->CekForm($idsistem_sistem, $idlevel);
                    $idform_user = [];
                    $akses_user = [];
    
                    if (is_array($dtform) && count($dtform) > 0) {
                        foreach ($dtform as $dx) {
                            array_push($idform_user, $dx->id_form);
                            if ($dx->id_form == $idform) {
                                array_push($akses_user, $dx->akses);
                            }
                        }
    
                        $ids = $idsistem_sistem;
                        $idf = $idform;
                        $akses = "";
                        $hal = ($jenis == "dashboard") ? $idsistem_sistem : $idform;
    
                        // Cek apakah $akses_user memiliki elemen sebelum diakses
                        if (!empty($akses_user)) {
                            $akses = $akses_user[0];
                        }
    
                        if (array_search($idform, $idform_user) !== false) {
                            $hal = $idform;
                        }
                    }
                }
            }
        }
    
        return $status ? [$status, $dtlogin, $akses, $dtmenu, $dtform, $ids, $idf, $hal] : [$status, "", ""];
    }
    
}
