<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Front');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override(function(){return view("hal404");});
$routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.

$routes->get('/', 'Sistem::index');
$routes->get('viewlogin', 'Sistem::viewLogin');
$routes->get('signin', 'Sistem::index');
$routes->get('setpass', 'Sistem::setpass');
$routes->post('login', 'Sistem::Login');
$routes->post('gantipassword', 'Sistem::UpdatePassword');
$routes->get('logout', 'Sistem::Logout');
$routes->get('beranda', 'Dashboard::index');
//------------------------------------------------------------
$routes->get('001', 'Basis::x001');
$routes->get('002', 'Basis::x002');
$routes->get('003', 'Basis::x003');
//------------------------------------------------------------
$routes->get('Dr699', 'Dr699::index');
$routes->group('Dr699', function($routes){
    $routes->get('data', 'Dr699::json');
    $routes->post('filter', 'Dr699::filter');
    $routes->post('tambah', 'Dr699::add');
    $routes->post('edit', 'Dr699::update');
    $routes->post('hapus', 'Dr699::delete');
});
//------------------------------------------------------------
$routes->get('Ak755', 'Ak755::index');
$routes->group('Ak755', function($routes){
    $routes->get('data', 'Ak755::json');
    $routes->post('filter', 'Ak755::filter');
    $routes->post('tambah', 'Ak755::add');
    $routes->post('edit', 'Ak755::update');
    $routes->post('hapus', 'Ak755::delete');
    $routes->post('reset', 'Ak755::reset');
});

// Data Wali santri
$routes->get('/wali', 'Wali::index');
$routes->get('/datawali', 'Wali::getWali');
$routes->post('/tambahwali', 'Wali::TambahWali');
$routes->post('/filterwali', 'Wali::AmbilWali');
$routes->post('/updatewali', 'Wali::UpdateWali');
$routes->post('/hapuswali', 'Wali::HapusWali');

// Face
$routes->get('/face', 'Face::index');
$routes->post('/cek', 'Face::cek');

// Data Riwayat Berkunjung
$routes->get('/riwayat', 'Riwayat::index');
$routes->get('/datariwayat', 'Riwayat::getRiwayat');

$routes->get('imporExcel', 'Excel::index');
$routes->post('prosesexcel', 'Excel::upload');



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
